/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.handlers.email;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.Validators;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.accounts.Account;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class EmailAccount
extends Account {
    public static final String TYPE = "email";
    private String host;
    private int port = 25;
    private String user;
    private String password;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private Integer sessionTimeout;
    private boolean simulate;
    private boolean debug;
    private boolean enableTls;
    private boolean enableStartTls;
    private boolean trustAll;
    private List<String> trustedHosts;
    private String defaultFrom;
    private List<String> defaultTo;
    private List<String> defaultCc;
    private List<String> defaultBcc;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public boolean isSimulate() {
        return this.simulate;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isEnableTls() {
        return this.enableTls;
    }

    public void setEnableTls(boolean enableTls) {
        this.enableTls = enableTls;
    }

    public boolean isEnableStartTls() {
        return this.enableStartTls;
    }

    public void setEnableStartTls(boolean enableStartTls) {
        this.enableStartTls = enableStartTls;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public List<String> getTrustedHosts() {
        return this.trustedHosts;
    }

    public void setTrustedHosts(List<String> trustedHosts) {
        this.trustedHosts = trustedHosts;
    }

    public String getDefaultFrom() {
        return this.defaultFrom;
    }

    public void setDefaultFrom(String defaultFrom) {
        this.defaultFrom = defaultFrom;
    }

    public List<String> getDefaultTo() {
        return this.defaultTo;
    }

    public void setDefaultTo(List<String> defaultTo) {
        this.defaultTo = defaultTo;
    }

    public List<String> getDefaultCc() {
        return this.defaultCc;
    }

    public void setDefaultCc(List<String> defaultCc) {
        this.defaultCc = defaultCc;
    }

    public List<String> getDefaultBcc() {
        return this.defaultBcc;
    }

    public void setDefaultBcc(String ... defaultBcc) {
        this.defaultBcc = Arrays.asList(defaultBcc);
    }

    public void setDefaultBcc(List<String> defaultBcc) {
        this.defaultBcc = defaultBcc;
    }

    @Override
    public SearchSourceBuilder getReferencingWatchesQuery() {
        return new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"actions.type", (String)TYPE)).must((QueryBuilder)QueryBuilders.termQuery((String)"actions.account", (String)this.getId())));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", TYPE);
        builder.field("_name", this.getId());
        builder.field("host", this.host);
        builder.field("port", this.port);
        if (this.user != null) {
            builder.field("user", this.user);
        }
        if (this.password != null) {
            builder.field("password", this.password);
        }
        if (this.proxyHost != null) {
            builder.field("proxy_host", this.proxyHost);
        }
        if (this.proxyPort != null) {
            builder.field("proxy_port", this.proxyPort);
        }
        if (this.proxyUser != null) {
            builder.field("proxy_user", this.proxyUser);
        }
        if (this.sessionTimeout != null) {
            builder.field("session_timeout", this.sessionTimeout);
        }
        if (this.simulate) {
            builder.field("simulate", true);
        }
        if (this.debug) {
            builder.field("debug", true);
        }
        if (this.enableTls) {
            builder.field("enable_tls", true);
        }
        if (this.enableStartTls) {
            builder.field("enable_start_tls", true);
        }
        if (this.trustAll) {
            builder.field("trust_all", true);
        }
        if (this.trustedHosts != null) {
            builder.field("trusted_hosts", this.trustedHosts);
        }
        if (this.defaultFrom != null) {
            builder.field("default_from", this.defaultFrom);
        }
        if (this.defaultTo != null) {
            builder.field("default_to", this.defaultTo);
        }
        if (this.defaultCc != null) {
            builder.field("default_cc", this.defaultCc);
        }
        if (this.defaultBcc != null) {
            builder.field("default_bcc", this.defaultBcc);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static class Factory
    extends Account.Factory<EmailAccount> {
        public Factory() {
            super(EmailAccount.TYPE);
        }

        @Override
        protected EmailAccount create(String id, ValidatingDocNode vJsonNode, ValidationErrors validationErrors) throws ConfigValidationException {
            EmailAccount result = new EmailAccount();
            result.setId(id);
            result.host = vJsonNode.get("host").required().asString();
            result.port = vJsonNode.get("port").required().asInt();
            if (vJsonNode.hasNonNull("user")) {
                result.user = vJsonNode.get("user").asString();
                result.password = vJsonNode.get("password").asString();
            } else if (vJsonNode.hasNonNull("password")) {
                validationErrors.add(new ValidationError("user", "A user must be specified if a password is specified"));
            }
            result.proxyHost = vJsonNode.get("proxy_host").asString();
            result.proxyPort = vJsonNode.get("proxy_port").asInteger();
            result.proxyUser = vJsonNode.get("proxy_user").asString();
            result.proxyPassword = vJsonNode.get("proxy_password").asString();
            result.sessionTimeout = vJsonNode.get("session_timeout").asInteger();
            result.simulate = vJsonNode.get("simulate").withDefault(false).asBoolean();
            result.debug = vJsonNode.get("debug").withDefault(false).asBoolean();
            result.enableTls = vJsonNode.get("enable_tls").withDefault(false).asBoolean();
            result.enableStartTls = vJsonNode.get("enable_start_tls").withDefault(false).asBoolean();
            result.trustAll = vJsonNode.get("trust_all").withDefault(false).asBoolean();
            result.trustedHosts = (List)vJsonNode.get("trusted_hosts").asListOfStrings();
            result.defaultFrom = ((ValidatingDocNode.StringAttribute)vJsonNode.get("default_from").validatedBy(Validators.EMAIL_WITH_DISPLAY_NAME).expected("An eMail address")).asString();
            result.defaultTo = (List)((ValidatingDocNode.StringListAttribute)vJsonNode.get("default_to").asList().validatedBy(Validators.EMAIL_WITH_DISPLAY_NAME).expected("A list of eMail addresses")).ofStrings();
            result.defaultCc = (List)((ValidatingDocNode.StringListAttribute)vJsonNode.get("default_cc").asList().validatedBy(Validators.EMAIL_WITH_DISPLAY_NAME).expected("A list of eMail addresses")).ofStrings();
            result.defaultBcc = (List)((ValidatingDocNode.StringListAttribute)vJsonNode.get("default_bcc").asList().validatedBy(Validators.EMAIL_WITH_DISPLAY_NAME).expected("A list of eMail addresses")).ofStrings();
            validationErrors.throwExceptionForPresentErrors();
            return result;
        }

        @Override
        public Class<EmailAccount> getImplClass() {
            return EmailAccount.class;
        }
    }
}

